'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Detailbereich_Format(Cancel As Integer, FormatCount As Integer)
    'MwSt-Splitting-Tabelle ein-/ausschalten
    If Me.Kasten_MwSt_Splitting.Value = False Then
        Me.Storno_MwSt_Splitting.Visible = False                        'Splitting-Tabelle
        Me.Ueber_MwSt_Kz.Visible = False                                'Kz-berschrift hier
       Me.Parent.Ueber_MwSt_Kz.Visible = False                          'Kz-berschrift im bergeord. Formular
    Else
        Me.Storno_MwSt_Splitting.Visible = True                         'Splitting-Tabelle
        Me.Ueber_MwSt_Kz.Visible = True                                 'Kz-berschrift hier
        Me.Parent.Ueber_MwSt_Kz.Visible = True                          'Kz-berschrift im bergeord. Formular
    End If
End Sub

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    
    'berschrift des Storno einstellen
    Me.Ueberschrift.Caption = FormularStornoUeberschrift
    
    'berschrift fr Dauer einstellen
    Select Case FormatTermindauer
        Case 0      'Minuten  (Bsp.: 105)
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten/berechnet"
        Case 4      'Dezimalstunden  (1,75)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std/berechnet"
        Case 8      'Std:Min  (01:45)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std:Min/berechnet"
        Case Else
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten/berechnet"
    End Select
    
    'aktuelles Whrungsformat des Systems einstellen
    Me.Text70.Format = "Currency"           'Rechnungs-Netto
    Me.Text72.Format = "Currency"           'Rechnungs-MwSt
    Me.Text74.Format = "Currency"           'Rechnungs-Brutto
End Sub
